// normally the model is passed to the view instead of the view creating the model
define([
    'backbone',
    'marionette',
    'text!modules/new-appointment-request/views/requests/date-time/template.html',
    'modules/new-appointment-request/views/requests/date-time/section-view',
    'json!modules/new-appointment-request/views/requests/form.json',
],
function(
    Backbone,
    Marionette,
    template,
    OptionDateTimeSectionView,
    metadata
) {
    'use strict';

    return Backbone.Marionette.View.extend({
        tagName: 'fieldset',
        template: template,
        regions: {
            'dateTime1Region': '.desired-appointment-date-time-section:first-of-type',
            'dateTime2Region': '.desired-appointment-date-time-section:nth-of-type(2)',
            'dateTime3Region': '.desired-appointment-date-time-section:nth-of-type(3)',
        },
        initialize: function(options) {
            this.initializeDateRangeData();
            if (options.model) {
                this.model = options.model;
            }
        },
        initializeDateRangeData: function() {
            var today = new Date();
            var minDate = new Date(today);
            var maxDate = new Date(today);
            var earliestDateInc = 5;
            var latestDateInc = 90;

            minDate.setDate(minDate.getDate() + earliestDateInc);
            maxDate.setDate(maxDate.getDate() + latestDateInc);

            // is static, without eventing needed, so not creating model
            this.dateRangeData = {
                minDate: minDate,
                maxDate: maxDate,
            };
        },
        serializeData: function() {
            return this.dateRangeData;
        },
        onRender: function() {
            var totalSections = 3;
            this.showDateTimeSectionViews(totalSections);
        },
        onDestroy: function() {
            delete this.dateRangeData;
        },
        showDateTimeSectionViews: function(totalSections) {
            var sectionNumber = 1;
            for (sectionNumber; sectionNumber <= totalSections; sectionNumber++) {
                this.showDateTimeSectionView(sectionNumber);
            }
        },
        showDateTimeSectionView: function(sectionNumber) {
            var name = 'dateTime' + sectionNumber + 'Region';
            var region = this.getRegion(name);

            region.show(new OptionDateTimeSectionView({
                sectionNumber: sectionNumber,
                model: this.model,
                isCCRequest: this.model.has('careType'),
                minDate: this.dateRangeData.minDate,
                maxDate: this.dateRangeData.maxDate,
            }));
        },
    });
});
